local assets=
{
	Asset("ANIM", "anim/bullet.zip"),
}

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("bullet")
    inst.AnimState:SetBuild("bullet")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM   
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bullet.xml"

	return inst
end

STRINGS.NAMES.BULLET = "Ammo Bag"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BULLET = "Shooting！"

return Prefab( "common/inventory/bullet", fn, assets) 
